module.exports = (sequelize, DataTypes) => {
  const StudyGoalProgram = sequelize.define(
    "StudyGoalProgram",
    {
      name: {
        type: DataTypes.STRING,
        allowNull: false,
      },
      studyGoalId: {
        type: DataTypes.INTEGER,
        field: "study_goal_id",
        allowNull: false,
      },
      collegeCount: {
        type: DataTypes.INTEGER,
        field: "college_count",
        defaultValue: 0,
      },
      isActive: {
        type: DataTypes.BOOLEAN,
        field: "is_active",
        defaultValue: true,
      },
    },
    {
      tableName: "study_goal_programs",
      timestamps: true,
      underscored: true,
    }
  );

  return StudyGoalProgram;
};
