module.exports = (sequelize, DataTypes) => {
  const CollegeVideo = sequelize.define(
    "tbl_college_videos",
    {
      video_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      fk_college_id: DataTypes.INTEGER,
      video_url: DataTypes.STRING(250),
    },
    {
      tableName: "tbl_college_videos",
      timestamps: false,
    }
  );

  CollegeVideo.associate = (models) => {
    CollegeVideo.belongsTo(models.College, {
      foreignKey: "fk_college_id",
      as: "college",
    });
  };

  return CollegeVideo;
};
