module.exports = (sequelize, DataTypes) => {
  const CollegeImage = sequelize.define(
    "tbl_college_images",
    {
      image_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      fk_college_id: DataTypes.INTEGER,
      image_url: DataTypes.STRING(500),
      is_cover: DataTypes.TINYINT,
      is_logo: DataTypes.TINYINT,
    },
    {
      tableName: "tbl_college_images",
      timestamps: false,
    }
  );

  CollegeImage.associate = (models) => {
    CollegeImage.belongsTo(models.College, {
      foreignKey: "fk_college_id",
      as: "college",
    });
  };

  return CollegeImage;
};
