// models/CollegeCourse.js
module.exports = (sequelize, DataTypes) => {
  const CollegeCourse = sequelize.define(
    "CollegeCourse",
    {
      course_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      fk_college_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
          model: "tbl_college",
          key: "college_id",
        },
      },
      college_id: {
        // Add this virtual field
        type: DataTypes.INTEGER,
        field: "fk_college_id", // Maps to the actual column
        allowNull: false,
        references: {
          model: "tbl_college",
          key: "college_id",
        },
      },
      course_name: {
        type: DataTypes.TEXT,
        allowNull: false,
      },
      course_fees: {
        type: DataTypes.DOUBLE,
        allowNull: true,
      },
      degree_approval: {
        type: DataTypes.STRING(1000),
        allowNull: true,
      },
      course_mode: {
        type: DataTypes.STRING(250),
        allowNull: true,
      },
      course_duration: {
        type: DataTypes.STRING(250),
        allowNull: true,
      },
      course_strength: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
    },
    {
      tableName: "tbl_college_courses",
      timestamps: false,
      freezeTableName: true,
      underscored: true,
    }
  );

  CollegeCourse.associate = function (models) {
    CollegeCourse.belongsTo(models.College, {
      foreignKey: "fk_college_id", // Make sure this matches your database column
      targetKey: "college_id",
      as: "college",
    });
  };

  return CollegeCourse;
};
