// model
const categories = require("../../models/Blog/categories");

module.exports = (sequelize, DataTypes) => {
  const Blog = sequelize.define(
    "Blog",
    {
      title: {
        type: DataTypes.STRING,
        allowNull: false,
        validate: {
          notEmpty: true,
        },
      },
      featuredImage: {
        type: DataTypes.STRING,
        field: "featured_image",
      },
      category: {
        type: DataTypes.STRING,
        allowNull: false,
        validate: {
          notEmpty: true,
          isIn: [categories],
        },
      },
      author: {
        type: DataTypes.STRING,
        allowNull: false,
      },
      description: {
        type: DataTypes.TEXT,
        allowNull: false,
      },
      metaKeywords: {
        type: DataTypes.TEXT,
        field: "meta_keywords",
      },
      metaDescription: {
        type: DataTypes.TEXT,
        field: "meta_description",
      },
      altTag: {
        type: DataTypes.STRING,
        field: "alt_tag",
      },
      url: {
        type: DataTypes.STRING,
        unique: true,
      },
      category: {
        type: DataTypes.STRING,
      },
      tags: {
        type: DataTypes.STRING(500),
      },
      status: {
        type: DataTypes.ENUM("draft", "published", "archived"),
        defaultValue: "draft",
      },
      featuredImage: {
        type: DataTypes.STRING,
        field: "featured_image",
      },
    },
    {
      tableName: "blogs",
      timestamps: true,
      underscored: true,
      paranoid: true,
    }
  );

  return Blog;
};
