const convertBufferFields = (data) => {
  if (!data) return data;

  const processField = (field) => {
    if (!field) return null;
    if (typeof field === "string") return field;
    if (field.type === "Buffer" && Array.isArray(field.data)) {
      return Buffer.from(field.data).toString("utf8");
    }
    return field.toString("utf8");
  };

  const plainData = data.get ? data.get({ plain: true }) : data;

  return {
    ...plainData,
    ppsDescription: processField(plainData.ppsDescription),
    pps_meta_descriptions: processField(plainData.pps_meta_descriptions),
    storyData:
      plainData.storyData?.map((item) => ({
        ...item,
        ppsdDescription: processField(item.ppsdDescription),
      })) || [],
  };
};

module.exports = {
  convertBufferFields,
};
