const express = require("express");
const router = express.Router();
const landingPageController = require("../../controllers/LandingPageController/landingPageController");

// Landing Page CRUD routes
router.post("/landing-pages", landingPageController.createLandingPage);
router.get("/landing-pages", landingPageController.getLandingPage);
router.put("/landing-pages/:id", landingPageController.updateLandingPage);
router.delete("/landing-pages/:id", landingPageController.deleteLandingPage);

// Company CRUD routes
router.post("/companies", landingPageController.createCompany);
router.get("/companies", landingPageController.getCompanies);
router.put("/companies/:id", landingPageController.updateCompany);
router.delete("/companies/:id", landingPageController.deleteCompany);

module.exports = router;
