module.exports = (sequelize, DataTypes) => {
  const Notification = sequelize.define(
    "Notification",
    {
      id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      title: {
        type: DataTypes.STRING,
        allowNull: false,
      },
      content: {
        type: DataTypes.TEXT,
        allowNull: false,
      },
      category: {
        type: DataTypes.ENUM("All", "National", "State"),
        defaultValue: "All",
      },
    },
    {
      tableName: "exam_notifications",
      timestamps: true,
      underscored: true,
    }
  );

  return Notification;
};
