module.exports = (sequelize, DataTypes) => {
  const Student = sequelize.define(
    "tbl_student",
    {
      student_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      applied_in: DataTypes.STRING(100),
      appling_for: {
        type: DataTypes.ENUM("MBA", "UG"),
        allowNull: false,
      },
      fb_user_id: DataTypes.STRING(1000),
      first_name: DataTypes.STRING(250),
      middle_name: DataTypes.STRING(250),
      last_name: DataTypes.STRING(250),
      email_id: {
        type: DataTypes.STRING(250),
        unique: true,
      },
      // Include all other fields from your table
      // ...
      signup_date: {
        type: DataTypes.DATE,
        defaultValue: DataTypes.NOW,
      },
    },
    {
      tableName: "tbl_student",
      timestamps: false,
      underscored: true,
    }
  );

  return Student;
};
