module.exports = (sequelize, DataTypes) => {
  const College = sequelize.define(
    "tbl_college",
    {
      college_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      college_name: DataTypes.TEXT,
      college_city_name: DataTypes.STRING(250),
      college_state_name: DataTypes.STRING(250),
      logo_image_url: DataTypes.STRING(1000),
      college_desc: DataTypes.TEXT,
      college_facilities: DataTypes.TEXT,
      college_website: DataTypes.TEXT,
      college_contact: DataTypes.STRING(500),
      college_email: DataTypes.STRING(500),
      college_address: DataTypes.TEXT,
      estd_year: DataTypes.STRING(250),
      is_featured: DataTypes.TINYINT,
      collage_page_title: DataTypes.TEXT,
      collage_meta_desc: DataTypes.TEXT,
      collage_meta_char: DataTypes.TEXT,
    },
    {
      tableName: "tbl_college",
      timestamps: false,
      underscored: true,
    }
  );
  College.associate = (models) => {
    College.hasOne(models.CollegeComparison, {
      foreignKey: "fk_college_id",
      as: "comparisonData",
    });
    College.hasMany(models.CollegeCourse, {
      foreignKey: "fk_college_id",
      as: "courses",
    });
    College.hasMany(models.CollegeImage, {
      foreignKey: "fk_college_id",
      as: "images",
    });
    College.hasMany(models.CollegeReview, {
      foreignKey: "fk_college_id",
      as: "reviews",
    });
    College.hasMany(models.CollegeVideo, {
      foreignKey: "fk_college_id",
      as: "videos",
    });
  };

  return College;
};
