module.exports = (sequelize, DataTypes) => {
  const Exam = sequelize.define(
    "Exam",
    {
      name: {
        type: DataTypes.STRING,
        allowNull: false,
        unique: true,
      },
      shortName: {
        type: DataTypes.STRING,
        field: "short_name",
      },
      examDate: {
        type: DataTypes.DATE,
        field: "exam_date",
      },
      applicationStartDate: {
        type: DataTypes.DATE,
        field: "application_start_date",
      },
      applicationEndDate: {
        type: DataTypes.DATE,
        field: "application_end_date",
      },
      level: {
        type: DataTypes.STRING,
      },
      isActive: {
        type: DataTypes.BOOLEAN,
        field: "is_active",
        defaultValue: true,
      },
      displayOrder: {
        type: DataTypes.INTEGER,
        field: "display_order",
        defaultValue: 0,
      },
    },
    {
      tableName: "exams",
      timestamps: true,
      underscored: true,
    }
  );

  return Exam;
};
