const express = require("express");
const cors = require("cors");
const db = require("./models");
const collegeRoutes = require("./routes/college/collegeRoutes");
const landingPageRoutes = require("./routes/college/landingPageRoute");
const authRoutes = require("./routes/authRoutes");
const importantdateRoute = require("./routes/college/importantdateRoute");
const companyRoutes = require("./routes/college/companiesRoute");
const path = require("path");
const blogRouter = require("./routes/blog/blogRoute");
const blogtag = require("./routes/blog/blogTagRoute");
const blogcategory = require("./routes/blog/blogCategoryRoute");
const blogcomments = require("./routes/blog/blogCommentsRoutes");
const students = require("./routes/students/student.routes");
const banner = require("./routes/BannerRoutes");
const studygoal = require("./routes/studyGoalRoutes");
const examroute = require("./routes/examRoutes");
const courseroute = require("./routes/courseRoutes");
const notificationroute = require("./routes/notificationRoutes");
const collegeComparison = require("./routes/collegeComparisonRoutes");
const user = require("./routes/mainAuthRoute");
// const collegeCourseRoutes = require("./routes/collegeCourseRoutes");
const landingPage = require("./routes/LandingPageRoutes/landingPageRoutes");
const studentRoutes = require("./routes/students/studentRoutes");

const fileUpload = require("express-fileupload");
const app = express();
app.use("/uploads", express.static(path.join(__dirname, "public/uploads")));
app.use(cors());
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
// app.use("/uploads", express.static("uploads"));
app.use(
  "/uploads/companies",
  express.static(path.join(__dirname, "uploads/companies"))
);
app.use(
  "/uploads/banners",
  express.static(path.join(__dirname, "uploads/banners"))
);
app.use(fileUpload());

app.use("/auth", authRoutes);
app.use("/api/colleges", collegeRoutes);
app.use("/api/landingpage", landingPageRoutes);
app.use("/api/importantdate", importantdateRoute);
app.use("/api/companies", companyRoutes);
app.use("/api/blogs", blogRouter);
app.use("/api/blogtag", blogtag);
app.use("/api/blogcategory", blogcategory);
app.use("/api/blogcomments", blogcomments);
app.use("/api/students", students);
app.use("/api/banner", banner);
app.use("/api/study-goal", studygoal);
app.use("/api/top-exams", examroute);
app.use("/api/courses", courseroute);
app.use("/api/notification", notificationroute);
app.use("/api/collegecomparison", collegeComparison);
app.use("/api/user", user);
app.use("/api/", landingPage);
app.use("/api/students", studentRoutes);
app.use("/api/college-detail", require("./routes/GroupAPI/GroupRouteAPI"));
app.use("/api/stories", require("./routes/blog/ppStoryRoutes"));

// app.use("/api/courses", collegeCourseRoutes);

// app.use("/api/banner", banner);

// Sync DB and start server
db.sequelize.sync().then(() => {
  app.listen(5000, () => {
    console.log("Server running on http://localhost:5000");
  });
});
