const { Sequelize, DataTypes } = require("sequelize");

const sequelize = new Sequelize("gogyani_bmcdb", "gogyani_bmcuser", "CXuY##G8Abe!", {
  host: "localhost",
  dialect: "mysql",
  logging: false,
  pool: {
    max: 5,
    min: 0,
    acquire: 30000,
    idle: 10000,
  },
});

const db = {};
db.sequelize = sequelize;
db.Sequelize = Sequelize;

// Initialize models
db.College = require("./models/collegeModel/collegeModel")(
  sequelize,
  DataTypes
);
db.Landingpage = require("./models/collegeModel/landingPageModel")(
  sequelize,
  DataTypes
);
db.Company = require("./models/collegeModel/CompanyModel")(
  sequelize,
  DataTypes
);
db.ImportantDate = require("./models/collegeModel/importantdateModel")(
  sequelize,
  DataTypes
);
db.Blog = require("./models/Blog/blogModel")(sequelize, DataTypes);
db.BlogTag = require("./models/Blog/blogTagModel")(sequelize, DataTypes);
db.BlogComments = require("./models/Blog/blogCommentsModel")(
  sequelize,
  DataTypes
);
db.BlogCategory = require("./models/Blog/blogCategoryModel")(
  sequelize,
  DataTypes
);
db.StudentUG = require("./models/Students/studentUG.model")(
  sequelize,
  DataTypes
);
db.StudentMBA = require("./models/Students/studentMBA.model")(
  sequelize,
  DataTypes
);
db.Student = require("./models/Students/studentModel")(sequelize, DataTypes);
db.Banner = require("./models/BannerModel")(sequelize, DataTypes);

// Add StudyGoal models
db.StudyGoal = require("./models/StudyGoal/studyGoalModel")(
  sequelize,
  DataTypes
);
db.StudyGoalProgram = require("./models/StudyGoal/studyGoalProgramModel")(
  sequelize,
  DataTypes
);

// Define relationships
db.StudyGoal.hasMany(db.StudyGoalProgram, {
  foreignKey: "study_goal_id",
  as: "programs",
});

db.StudyGoalProgram.belongsTo(db.StudyGoal, {
  foreignKey: "study_goal_id",
  as: "studyGoal",
});

db.Exam = require("./models/ExamModel/examModel")(sequelize, DataTypes);
db.Course = require("./models/ExploreCourse/course.model")(
  sequelize,
  DataTypes
);
db.Notification = require("./models/notificationModel")(sequelize, DataTypes);
// db.College = require("./models/collegeModel")(sequelize, DataTypes);
db.CollegeComparison = require("./models/CollegeComparison")(
  sequelize,
  DataTypes
);

// Add associations
db.College.hasOne(db.CollegeComparison, {
  foreignKey: "fk_college_id",
  as: "comparisonData",
});

db.CollegeComparison.belongsTo(db.College, {
  foreignKey: "fk_college_id",
  as: "college",
});
db.User = require("./models/UserModel/userModel")(sequelize, DataTypes);

// Add this to your db.js file
db.CollegeCourse = require("./models/CollegeCourse")(sequelize, DataTypes);

db.College.hasMany(db.CollegeCourse, {
  foreignKey: "college_id",
  as: "courses",
});

db.CollegeCourse.belongsTo(db.College, {
  foreignKey: "college_id",
  as: "college",
});

// LANDING PAGE

db.College = require("./models/LandingPageModel/companyModel")(
  sequelize,
  DataTypes
);
db.LandingPage = require("./models/LandingPageModel/landingPageModel")(
  sequelize,
  DataTypes
);

// LandingPage belongs to College
db.LandingPage.belongsTo(db.College, {
  foreignKey: "college_id",
  as: "college",
});

db.College.hasOne(db.LandingPage, {
  foreignKey: "college_id",
  as: "landingPage",
});

// MAIN API
db.College = require("./models/GroupAPI/collegeModel")(sequelize, DataTypes);
db.CollegeComparison = require("./models/CollegeComparison")(
  sequelize,
  DataTypes
);
db.CollegeCourse = require("./models/CollegeCourse")(sequelize, DataTypes);
db.CollegeImage = require("./models/GroupAPI/imageModel")(sequelize, DataTypes);
db.CollegeReview = require("./models/GroupAPI/reviewModel")(
  sequelize,
  DataTypes
);
db.CollegeVideo = require("./models/GroupAPI/videoModel")(sequelize, DataTypes);

// Initialize associations
// Object.keys(db).forEach((modelName) => {
//   if (db[modelName].associate) {
//     db[modelName].associate(db);
//   }
// });

// In your db.js file

// 1. First import all models
db.PPStory = require("./models/Blog/ppStoryModel")(sequelize, DataTypes);
db.PPStoryData = require("./models/Blog/ppStoryDataModel")(
  sequelize,
  DataTypes
);

// 2. Then set up associations using the following pattern:
// Don't call associate directly here - it should be called after all models are loaded

// 3. After all models are defined, set up associations
Object.keys(db).forEach((modelName) => {
  if (db[modelName].associate) {
    db[modelName].associate(db);
  }
});

// Test connection and sync models

// In your db.js, replace the sync section with:
// ... (previous code remains the same until the sync section)

// Test connection and sync models
(async () => {
  try {
    await sequelize.authenticate();
    console.log("Database connection has been established successfully.");
  } catch (error) {
    console.error("Unable to connect to the database:", error);
  }
})();

module.exports = db;
